/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.configurationProcessors;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.ide.core.io.LockUtils;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.configurationProcessors.InstallerConfigurationProcessor;
import com.aptana.portal.ui.dispatch.configurationProcessors.Messages;
import com.aptana.portal.ui.dispatch.configurationProcessors.installer.InstallerOptionsDialog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class RubyInstallProcessor
extends InstallerConfigurationProcessor {
    private static final String RUBY = "Ruby";
    protected static final String RUBY_DEFAULT_INSTALL_DIR = "C:\\Ruby";
    private static final int RUBY_INSTALLER_PROCESS_CANCEL = 5;
    private static boolean installationInProgress;
    private String installDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationStatus configure(IProgressMonitor progressMonitor, Object attributes) {
        block29: {
            block28: {
                Class<?> clazz;
                ConfigurationStatus configurationStatus;
                Class<?> clazz2 = ((Object)((Object)this)).getClass();
                synchronized (clazz2) {
                    if (installationInProgress) {
                        return this.configurationStatus;
                    }
                    installationInProgress = true;
                }
                if (!"win32".equals(Platform.getOS())) {
                    String err = "The Ruby installer processor is designed to work on Windows.";
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(err));
                    this.applyErrorAttributes(err);
                    installationInProgress = false;
                    return this.configurationStatus;
                }
                try {
                    this.configurationStatus.removeAttribute("configurations");
                    this.clearErrorAttributes();
                    IStatus loadingStatus = this.loadAttributes(attributes);
                    if (loadingStatus.isOK()) break block28;
                    String message = loadingStatus.getMessage();
                    this.applyErrorAttributes(message);
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
                    configurationStatus = this.configurationStatus;
                    clazz = ((Object)((Object)this)).getClass();
                }
                catch (Throwable throwable) {
                    Class<?> clazz3 = ((Object)((Object)this)).getClass();
                    synchronized (clazz3) {
                        installationInProgress = false;
                    }
                    throw throwable;
                }
                synchronized (clazz) {
                    installationInProgress = false;
                }
                return configurationStatus;
            }
            if (this.urls.length == 1) break block29;
            String err = NLS.bind((String)Messages.InstallProcessor_wrongNumberOfInstallLinks, (Object[])new Object[]{RUBY, 1, this.urls.length});
            this.applyErrorAttributes(err);
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(err));
            ConfigurationStatus configurationStatus = this.configurationStatus;
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                installationInProgress = false;
            }
            return configurationStatus;
        }
        this.installDir = (String)this.attributesMap.get("install_dir");
        if (this.installDir == null) {
            this.installDir = RUBY_DEFAULT_INSTALL_DIR;
        }
        this.configurationStatus.setStatus("processing");
        IStatus status = this.download(this.urls, progressMonitor);
        if (status.isOK()) {
            status = this.install(progressMonitor);
        }
        switch (status.getSeverity()) {
            case 0: 
            case 1: 
            case 2: {
                this.displayMessageInUIThread(2, NLS.bind((String)Messages.InstallProcessor_installerTitle, (Object)RUBY), NLS.bind((String)Messages.InstallProcessor_installationSuccessful, (Object)RUBY));
                this.configurationStatus.setStatus("ok");
                break;
            }
            case 4: {
                this.configurationStatus.setStatus("error");
                break;
            }
            case 8: {
                this.configurationStatus.setStatus("incomplete");
                break;
            }
            default: {
                this.configurationStatus.setStatus("unknown");
            }
        }
        ConfigurationStatus configurationStatus = this.configurationStatus;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            installationInProgress = false;
        }
        return configurationStatus;
    }

    protected String getApplicationName() {
        return RUBY;
    }

    protected IStatus install(IProgressMonitor progressMonitor) {
        if (CollectionsUtil.isEmpty((Collection)this.downloadedPaths) || CollectionsUtil.getFirstElement((List)this.downloadedPaths) == null) {
            String failureMessge = Messages.InstallProcessor_couldNotLocateInstaller;
            String err = NLS.bind((String)Messages.InstallProcessor_failedToInstall, (Object)RUBY);
            this.displayMessageInUIThread(1, Messages.InstallProcessor_installationErrorTitle, String.valueOf(err) + ' ' + failureMessge);
            return new Status(4, "com.aptana.portal.ui", String.valueOf(err) + ' ' + failureMessge);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.InstallProcessor_installerProgressInfo, (int)-1);
        try {
            subMonitor.beginTask(NLS.bind((String)Messages.InstallProcessor_installingTaskName, (Object)RUBY), -1);
            final IPath[] installDir = new IPath[1];
            UIJob installRubyDialog = new UIJob("Ruby installer options"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    RubyInstallerOptionsDialog dialog = new RubyInstallerOptionsDialog();
                    if (dialog.open() == 0) {
                        installDir[0] = Path.fromOSString((String)dialog.getInstallDir());
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            installRubyDialog.schedule();
            try {
                installRubyDialog.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IStatus result = installRubyDialog.getResult();
            if (!result.isOK()) {
                IStatus iStatus = result;
                return iStatus;
            }
            IStatus status = this.installRuby(installDir[0]);
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)("Successfully installed Ruby into " + installDir[0]));
            this.finalizeInstallation(installDir[0]);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Error while installing Ruby", (Throwable)e);
            Status status = new Status(4, "com.aptana.portal.ui", NLS.bind((String)Messages.InstallProcessor_errorWhileInstalling, (Object)RUBY));
            return status;
        }
        finally {
            subMonitor.done();
        }
    }

    protected IStatus installRuby(final IPath installDir) {
        Job job = new Job(NLS.bind((String)Messages.InstallProcessor_installerJobName, (Object)("Ruby " + Messages.InstallProcessor_installerGroupTitle))){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
                    subMonitor.beginTask(NLS.bind((String)Messages.InstallProcessor_installingTaskName, (Object)RubyInstallProcessor.RUBY), -1);
                    IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)("Installing Ruby into " + installDir));
                    IPath downloadPath = (IPath)RubyInstallProcessor.this.downloadedPaths.get(0);
                    IStatus fileLockStatus = LockUtils.waitForLockRelease((String)downloadPath.toOSString(), (long)10000L);
                    if (!fileLockStatus.isOK()) {
                        Status status = new Status(4, "com.aptana.portal.ui", NLS.bind((String)Messages.InstallProcessor_failedToInstallSeeLog, (Object)RubyInstallProcessor.RUBY));
                        return status;
                    }
                    ProcessBuilder processBuilder = new ProcessBuilder(downloadPath.toOSString(), "/silent", "/dir=\"" + installDir.toOSString() + "\"", "/tasks=\"modpath\"");
                    Process process = processBuilder.start();
                    int res = process.waitFor();
                    if (res == 5) {
                        IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)"Ruby installation cancelled");
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (res != 0) {
                        IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)("Failed to install Ruby. The ruby installer process returned a termination code of " + res));
                        Status status = new Status(4, "com.aptana.portal.ui", res, NLS.bind((String)Messages.InstallProcessor_installationErrorMessage, (Object)RubyInstallProcessor.RUBY, (Object)RubyInstallProcessor.RUBY), null);
                        return status;
                    }
                    if (!installDir.toFile().exists()) {
                        IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)("Failed to install Ruby. The " + installDir + " directory was not created"));
                        Status status = new Status(4, "com.aptana.portal.ui", res, NLS.bind((String)Messages.InstallProcessor_installationError_installDirMissing, (Object)RubyInstallProcessor.RUBY), null);
                        return status;
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
                    Status status = new Status(4, "com.aptana.portal.ui", NLS.bind((String)Messages.InstallProcessor_failedToInstallSeeLog, (Object)RubyInstallProcessor.RUBY), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.schedule(1000L);
        try {
            job.join();
        }
        catch (InterruptedException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            return Status.CANCEL_STATUS;
        }
        return job.getResult();
    }

    protected void finalizeInstallation(IPath installDir) {
        block12: {
            super.finalizeInstallation(installDir.toOSString());
            File propertiesFile = installDir.append(".aptana").toFile();
            Properties properties = new Properties();
            properties.put("ruby_install", this.urls[0]);
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(propertiesFile);
                    properties.store(fileOutputStream, NLS.bind((String)Messages.InstallProcessor_aptanaInstallationComment, (Object)"Ruby & DevKit"));
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
                    if (fileOutputStream == null) break block12;
                    try {
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private class RubyInstallerOptionsDialog
    extends InstallerOptionsDialog {
        public RubyInstallerOptionsDialog() {
            super(Display.getDefault().getActiveShell(), RubyInstallProcessor.RUBY);
            this.setTitleImage(PortalUIPlugin.getDefault().getImageRegistry().get("/icons/wizban/ruby.png"));
        }

        public String getInstallDir() {
            return this.attributes.get("install_dir").toString();
        }

        protected void setAttributes() {
            this.attributes.put("install_dir", RubyInstallProcessor.this.installDir);
        }
    }
}

